/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: ProfibusAps_diag.h 50785 2015-01-14 10:28:21Z mark $

Description:
  This file contains definition of Profibus Aps task diagnostic

**************************************************************************************/
#ifndef __PROFIBUS_APS_DIAG_H
#define __PROFIBUS_APS_DIAG_H

/////////////////////////////////////////////////////////////////////////////////////
// PROFIBUS APS Diagnostic Status codes
/////////////////////////////////////////////////////////////////////////////////////
//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_MS0_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to initialize the Slave's cyclic state machine failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_MS0_PACKET ((TLR_RESULT)0xC01D0001L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_MS1_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to initialize the Slave acyclic Master Class 1 state machine failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_MS1_PACKET ((TLR_RESULT)0xC01D0002L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_MS2_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to initialize the Slave acyclic Master Class 2 state machine failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_MS2_PACKET ((TLR_RESULT)0xC01D0003L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_SLAVE_DIAG_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send a Slave Diagnostic request failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_SLAVE_DIAG_PACKET ((TLR_RESULT)0xC01D0004L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_SET_CFG_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to set the new configuration data failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_SET_CFG_PACKET ((TLR_RESULT)0xC01D0005L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_CHECK_USER_PRM_RESULT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send back the user parameter checking result failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_CHECK_USER_PRM_RESULT_PACKET ((TLR_RESULT)0xC01D0006L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_CHECK_EXT_USER_PRM_RESULT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send back the extended user parameter checking result failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_CHECK_EXT_USER_PRM_RESULT_PACKET ((TLR_RESULT)0xC01D0007L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_CHECK_CFG_RESULT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send back the configuration data checking result failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_CHECK_CFG_RESULT_PACKET ((TLR_RESULT)0xC01D0008L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_GET_OUTPUT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send the request for getting the lastest outputs failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_GET_OUTPUT_PACKET ((TLR_RESULT)0xC01D0009L)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_APPLICATION_READY_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send the Applicaiton ready request failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_APPLICATION_READY_PACKET ((TLR_RESULT)0xC01D000AL)

//
// MessageId: TLR_DIAG_E_PROFIBUS_APS_NO_ABORT_PACKET
//
// MessageText:
//
//  Getting a packet from the pool to send the Applicaiton ready request failed.
//
#define TLR_DIAG_E_PROFIBUS_APS_NO_ABORT_PACKET ((TLR_RESULT)0xC01D000BL)




#endif  //__PROFIBUS_APS_DIAG_H

